<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model 
{

    protected $table = 'transactions';
    public $timestamps = true;
    protected $fillable = array('classe_id', 'fournisseur_id', 'projet_id', 'compte_id', 'regrouptrans_id', 'regroupcategorie_id', 'transcategorie_id', 'date', 'detail', 'montant');

    public function transtype()
    {
        return $this->belongsTo('App\Models\Transactiontype');
    }

    public function regrouptransac()
    {
        return $this->belongsTo('App\Models\Regroupetran');
    }

    public function regroupecategories()
    {
        return $this->belongsTo('App\Models\Regroupcategorie');
    }

    public function trancompte()
    {
        return $this->belongsTo('App\Models\Comptes');
    }

    public function transclasse()
    {
        return $this->belongsTo('App\Models\Regroupetran');
    }

    public function transprojet()
    {
        return $this->belongsTo('App\Models\Projet');
    }

    public function transacfournisseur()
    {
        return $this->belongsTo('App\Models\Fournisseurs');
    }

}